import dumper
import gdb

"""
value.type[0] is the type for the first template parameter

f=open("/tmp/debug", "w")
f.write(str(data))
f.write("\n")
f.close()

"""

def qdump__QGpCoreMath__Vector(d, value):
  count=value["_count"].integer()
  data=value["_values"].dereference()
  d.putItemCount(count)
  d.putPlotData(data.address(), count, value.type[0])
  
def qdump__QGpCoreMath__PrivateVector(d, value):
  count=value["_count"].integer()
  data=value["_values"].dereference()
  d.putItemCount(count)
  d.putPlotData(data.address(), count, value.type[0])
  
def qdump__QGpCoreMath__MatrixData(d, value):
  rowCount=value["_nrow"].integer()
  columnCount=value["_ncol"].integer()
  size=rowCount*columnCount
  data=value["_values"].dereference()
  d.putItemCount(size)
  d.putPlotData(data.address(), size, value.type[0])
  
def qdump__QGpCoreTools__Complex(d, value):
  d.putItemCount(2)
  d.putPlotData(value["_data"].address(), 2, d.createType("double"))

  
  
