/***************************************************************************
**
**  This file is part of waran.
**
**  waran is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  waran is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-07-14
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>
#include "RealTimeHistogram.h"

/*!
  \class RealTimeHistogram RealTimeHistogram.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
RealTimeHistogram::RealTimeHistogram()
    : IrregularGrid2D()
{
  TRACE;
  _currentX=-std::numeric_limits<double>::infinity();
  _currentCell=0;
}

void RealTimeHistogram::init(const SamplingParameters& xSampling, int yCount, double yMin, double yMax,
                             SamplingOption ySampling)
{
  TRACE;
  IrregularGrid2D::init(xSampling.count(), yCount);

  for(int i=xSampling.count()-1;i>=0;i--) {
    setX(i, xSampling.value(i));
  }
  if(ySampling & LogScale) {
    setLog(YAxis, yMin, yMax);
  } else {
    setLinear(YAxis, yMin, yMax);
  }
  clear();
  _currentX=-std::numeric_limits<double>::infinity();
  _currentCell=0;
}

void RealTimeHistogram::add(const Point2D& p)
{
  if(_currentX!=p.x()) {
    _currentX=p.x();
    int ix=indexOfX(_currentX);
    if(ix==1 || ix==nx()) return;
    _currentCell=valuePointer(ix, 0);
  }
  int iy=indexOfY(p.y());
  if(iy==1 || iy==ny()) return;
  _currentCell[ iy * nx() ]++;
}
