/***************************************************************************
**
**  This file is part of waran.
**
**  waran is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  waran is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-07-08
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef REALTIMEARRAYPROCESS_H
#define REALTIMEARRAYPROCESS_H

#include <ArrayCore.h>
#include <GeopsyCore.h>

class RealTimeArrayManager;
class RealTimeStationSignals;
class ArrayTask;
class PhaseShifter;

class RealTimeArrayProcess : public Thread
{
public:
  RealTimeArrayProcess(RealTimeArrayManager * manager, ArrayStations * array);
  ~RealTimeArrayProcess();

  void setKmin(double k);
  void setKmax(double k);
  void setFrequencyBands(const VectorList<GaussianFrequencyBand> * bands) {_bands=bands;}

  void terminate() {_terminate.fetchAndStoreOrdered(true);}
  bool terminated() const {return _terminate.testAndSetOrdered(true, true);}
  bool isWaiting() const {return _waiting.testAndSetOrdered(true, true);}
protected:
  virtual void run();
private:
  //void run(ArrayTask * t);
  bool lockTimeWindow(const TimeRange * r);
  void unlockTimeWindow();
  ComplexMatrix crossSpectrum(int component, const GaussianFrequencyBand& f);
  void fk(ComplexMatrix r, const FrequencyBand& f);
  void hrfk(ComplexMatrix r, const FrequencyBand& f);
  void spac(ComplexMatrix r, const FrequencyBand& f);

  RealTimeArrayManager * _manager;
  mutable QAtomicInt _terminate;
  mutable QAtomicInt _waiting;
  bool _signalsLocked;
  QList<RealTimeStationSignals *> _stations;

  const VectorList<GaussianFrequencyBand> * _bands;
  PhaseShifter * _phaseShifter;
  double _fkGridStep, _hrfkGridStep, _gridSize;
};

#endif // REALTIMEARRAYPROCESS_H
