/***************************************************************************
**
**  This file is part of waran.
**
**  waran is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  waran is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-08-18
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "NetworkParameterEditor.h"
#include "NetworkParameters.h"

/*!
  \class NetworkParameterEditor NetworkParameterEditor.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
NetworkParameterEditor::NetworkParameterEditor(QWidget * parent)
  : Dialog(parent)
{
  TRACE;
  setupUi(this);
}

/*!
  Description of destructor still missing
*/
NetworkParameterEditor::~NetworkParameterEditor()
{
  TRACE;
}

void NetworkParameterEditor::on_unitListBrowse_clicked()
{
  TRACE;
  QFileInfo fi(unitList->text());
  QString s=Message::getOpenFileName(tr("Unit list"), tr("Unit list (*)"), fi.dir().path());
  if(!s.isEmpty()) {
    unitList->setText(s);
  }
}

void NetworkParameterEditor::setValues(const NetworkParameters& p)
{
  TRACE;
  unitList->setText(p.unitList());
  acquisitionUnitPrefix->setText(p.acquisitionUnitPrefix());
  repeaterUnitPrefix->setText(p.repeaterUnitPrefix());
  processingUnit->setText(p.processingUnitName());
}

void NetworkParameterEditor::getValues(NetworkParameters& p)
{
  TRACE;
  p.setUnitList(unitList->text());
  p.setAcquisitionUnitPrefix(acquisitionUnitPrefix->text());
  p.setRepeaterUnitPrefix(repeaterUnitPrefix->text());
  p.setProcessingUnitName(processingUnit->text());
}
