/***************************************************************************
**
**  This file is part of spac2disp.
**
**  spac2disp is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  spac2disp is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-12-19
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "Spac2DispOptions.h"

/*
 *  Constructs a Spac2DispOptions as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 */
Spac2DispOptions::Spac2DispOptions(QWidget *parent, Qt::WindowFlags f)
    : QWidget(parent, f)
{
  TRACE;
  setupUi(this);
}

/*
 *  Destroys the object and frees any allocated resources
 */
Spac2DispOptions::~Spac2DispOptions()
{
  TRACE;
  // no need to delete child widgets, Qt does it all for us
}

bool Spac2DispOptions::isValid() const
{
  double kmin=kminEdit->value();
  double kmax=kmaxEdit->value();
  if(kmin>kmax) {
    Message::warning(MSG_ID, tr("Selecting samples"),
                      tr("kmin is greater than kmax."),
                      Message::cancel());
    return false;
  }
  if(kmin<1e-5) {
    Message::warning(MSG_ID, tr("Selecting samples"),
                      tr("kmin is less than 1e-5."),
                      Message::cancel());
    return false;
  }
  double vmin=vminEdit->value();
  double vmax=vmaxEdit->value();
  if(vmin>=vmax) {
    Message::warning(MSG_ID, tr("Selecting samples"),
                      tr("The minimum velocity must be less than the maximum velocity."),
                      Message::cancel());
    return false;
  }
  return true;
}
