/***************************************************************************
**
**  This file is part of screenpicker.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-07-15
**  Authors:

**
***************************************************************************/

#include <QGpGuiTools.h>

#include "MouseGrab.h"
#include "screenpickerVersion.h"
#include "screenpickerInstallPath.h"

PACKAGE_INFO("screenpicker", SCREENPICKER);

ApplicationHelp * help();

int main(int argc, char ** argv)
{
  Application a(argc, argv, help);

  // Options
  //<your option variable>
  // Check arguments
  int i, j = 1;
  for (i=1; i<argc; i++) {
    QByteArray arg = argv[i];
    if (arg[0]=='-') {
      if (arg=="<long option>" || arg=="<short option>") {
        CoreApplication::checkOptionArg(i, argc, argv);
        //<your option variable> = argv[i];
      } else {
        App::log(tr("screenpicker: bad option %1, see -help\n").arg(argv[i]));
        return 2;
      }
    } else {
      argv[j++] = argv[i];
    }
  }
  if(j < argc) {
    argv[j]=nullptr;
    argc=j;
  }

  MouseGrab * w=new MouseGrab;
  Settings::getWidget(w);
  w->show();

  int appReturn=a.exec();
  Settings::setWidget(w);
  delete w;
  return appReturn;
}

ApplicationHelp * help()
{
  TRACE;
  ApplicationHelp * h = new ApplicationHelp;
  h->setOptionSummary("[OPTIONS]");
  h->setComments("Pick a curve on the screen");
  //h->addGroup("screenpicker", "screenpicker");
  //h->addOption("<short option>, <long option>","<comments>");
  return h;
}
