/***************************************************************************
**
**  This file is part of screenpicker.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-07-15
**  Authors:
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef MOUSEGRAB_H
#define MOUSEGRAB_H

#include <QGpCoreMath.h>

#include "ui_MouseGrab.h"

class MouseGrab : public QWidget, private Ui::MouseGrab
{
  Q_OBJECT
public:
  MouseGrab(QWidget * parent=0);
  ~MouseGrab();

  virtual void mouseReleaseEvent(QMouseEvent * event);
private:
  void closeStream();

  QTextStream * _stream;
  int _count;
  double _realMinimumX, _realMaximumX, _realMinimumY, _realMaximumY;
  double _screenMinimumX, _screenMaximumX, _screenMinimumY, _screenMaximumY;
  bool _xLogScale, _yLogScale;
private slots:
  void on_startButton_clicked();
};

#endif // MOUSEGRAB_H
