/***************************************************************************
**
**  This file is part of phaseit.
**
**  phaseit is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  phaseit is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-12-07
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef WORKER_H
#define WORKER_H

#include <QGpCoreTools.h>

#include "TaskManager.h"

class ProcessSignals;

class Worker : public ParallelTaskWorker
{
public:
  Worker();
  ~Worker();

  void setTaskManager(TaskManager * tm);
protected:
  inline const TaskManager * taskManager() const;

  void process(ParallelTask * t);
private:
  void calculateFrequency(ProcessSignals * procStat, const Parameters * param,
                          int stationIndex, int windowIndex);
  void calculateTime(ProcessSignals * procStat, const Parameters * param,
                     int stationIndex, int windowIndex);

  ProcessSignals * _reference;
};

inline const TaskManager * Worker::taskManager() const
{
  return static_cast<const TaskManager *>(ParallelTaskWorker::taskManager());
}

#endif // WORKER_H

