/***************************************************************************
**
**  This file is part of max2curve.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-05-29
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef FKMAXENTRY_H
#define FKMAXENTRY_H

#include <math.h>

#include "MaxEntry.h"

class FKMaxEntry : public MaxEntry
{
public:
  virtual bool readLine(QTextStream& s);
  virtual void writeHeader(QTextStream& s) const;
  virtual void writeLine(QTextStream& s) const;
  static QByteArray fields();
  static bool isHeaderLine(QString f);

  virtual double value() const {return _slowness;}
  double slowness() const {return _slowness;}
  double wavenumber() const {return 2*M_PI*_x*_slowness;}
  double relativePower() const {return _relativePower;}
  double absolutePower() const {return _absolutePower;}

  void includePower(double& minRelPow, double& maxRelPow, double& minAbsPow, double& maxAbsPow);
private:
  double _slowness;
  double _azimuth;
  double _relativePower;
  double _absolutePower;
};

#endif // FKMAXENTRY_H
