/***************************************************************************
**
**  This file is part of matfiles.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2013-11-21
**  Authors:
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef MATARRAY_H
#define MATARRAY_H

#ifndef GP_MATLAB_LIBS

#include <QGpCoreTools.h>

class MatArray
{
public:
  MatArray();
  ~MatArray();

  enum Type {Undefined, CellArray, Structure, Object, CharArray, SparseArray, DoubleArray, FloatArray,
            Int8Array, UInt8Array, Int16Array, UInt16Array, Int32Array, UInt32Array,
            Int64Array, UInt64Array};

  void setFlags(quint32 f);
  void addDimension(qint32 d);
  void addNameChar(quint8 c);

  void setType(Type t) {_type=t;}
  Type type() const {return _type;}

  bool complex() const {return _complex;}

  void setName(const QString& n) {_name=n;}
  const QString& name() const {return _name;}

  int dimensionCount() const {return _dimensions.count();}
  int dimension(int index) const {return _dimensions.at(index);}
  qint64 dataCount() const;

  void allocateData();

  void setReal(int index, double val) {_realDouble[index]=val;}
  void setImaginary(int index, double val) {_imaginaryDouble[index]=val;}

  double * realDoubleValues() const {return _realDouble;}
private:
  Type _type;
  bool _complex;
  VectorList<qint32> _dimensions;
  QString _name;
  union {
    double * _realDouble;
  };
  union {
    double * _imaginaryDouble;
  };
};

#endif // GP_MATLAB_LIBS

#endif // MATARRAY_H
