/***************************************************************************
**
**  This file is part of gpviewmax.
**
**  gpviewmax is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpviewmax is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2022-11-08
**  Copyright: 2022
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef SAMPLEPLOT_H
#define SAMPLEPLOT_H

#include <SciFigs.h>

#include "Samples.h"

class SamplePlot : public GraphContentsLayer
{
  Q_OBJECT
  Q_PROPERTY(double dotDiameter READ dotDiameter WRITE setDotDiameter)
public:
  SamplePlot(AxisWindow * parent=nullptr);
  ~SamplePlot();

  const QString& xml_tagName() const {return xmlSamplePlotTag;}
  static const QString xmlSamplePlotTag;

  void setHistogram(Histogram2D * hist) {_hist=hist;}
  void setCategories(const Legend * c) {_categories=c;}

  double dotDiameter() const {return _dotDiameter;}
  void setDotDiameter (double d) {_dotDiameter=d;}

  Rect boundingRect() const;

  bool hasProperties() {return true;}
  void addProperties(PropertyProxy * pp);
  void removeProperties(PropertyProxy * pp);
  void properties(PropertyWidget * w) const;
  void setProperty(uint wid, int pid, QVariant val);
protected:
  void paintData(const LayerPainterRequest& lp, QPainter& p, double dotpercm) const;

  void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
  void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  void xml_writeBinaryData(XML_WRITEBINARYDATA_ARGS) const;
private:
  inline void drawDot(const GraphContentsOptions& gc, QPainter& p,
                      int pointSize, int halfSize,
                      const Histogram2D::Sample& sample) const;

  Histogram2D * _hist;
  const Legend * _categories;
  double _dotDiameter;

  static uint _tab;
};

#endif // SAMPLEPLOT_H

