/***************************************************************************
**
**  This file is part of gpviewmax.
**
**  gpviewmax is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpviewmax is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-07-16
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef SAMPLE_H
#define SAMPLE_H

#include <QGpCoreTools.h>

class Sample
{
public:
  Sample();

  bool read(const QString& line, int timeColumn, int freqColumn,
            int slowColumn, int azimuthColumn, int ellColumn,
            int verticalNoiseColumn, int horizontalNoiseColumn,
            int powerColumn, int validColumn);
  void writeValues(QTextStream& s) const;
  void writeLine(QTextStream& s) const {s<< _line << "\n";}

  const QString& time() const {return _time;}
  double frequency() const {return _frequency;}
  double slowness() const {return _slowness;}
  double ellipticity() const {return _ellipticity;}
  double verticalNoise() const {return _verticalNoise;}
  double horizontalNoise() const {return _horizontalNoise;}
  double totalNoise() const {return 2.0*_horizontalNoise+_verticalNoise;}
  double deltaNoise() const {return _verticalNoise-_horizontalNoise;}
  double sigmaNoise() const {return _horizontalNoise/_verticalNoise;}
  double xixDeviation() const;
  double xisDeviation() const;
  double azimuth() const {return _azimuth;}
  double power() const {return _power;}

  bool isValid() const {return _valid;}
  void setValid(bool v) {_valid=v;}

  const QString& line() const {return _line;}

  void convertEllipticity() {_ellipticity=Angle::radiansToDegrees(atan(_ellipticity));}
private:
  QString _time;
  double _frequency, _slowness, _azimuth, _ellipticity,
         _verticalNoise, _horizontalNoise, _power;
  QString _line;
  bool _valid;
};

#endif // SAMPLE_H

