/***************************************************************************
**
**  This file is part of gpviewmax.
**
**  gpviewmax is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpviewmax is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2022-11-24
**  Copyright: 2022
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "NoisePlotProxy.h"

/*!
  \class NoisePlotProxy NoisePlotProxy.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

void NoisePlotProxy::setXAxisProperties(Axis * a)
{
  TRACE;
  a->setScaleType(Scale::Log);
}

void NoisePlotProxy::setYAxisProperties(Axis * a)
{
  TRACE;
  //a->setRange(1e-3, 1e3);
  a->setScaleType(Scale::Log);
  a->setAutoTicks(false);
  a->setMajorTicks(10.0);
  a->setMinorTicks(2);
}

/*!
  Titles are already set.
*/
void NoiseDeltaPlotProxy::setYAxisProperties(Axis * a)
{
  TRACE;
  a->setScaleType(Scale::Linear);
  a->setAutoTicks(true);
}

/*!
  Titles are already set.
*/
void NoiseSigmaPlotProxy::setYAxisProperties(Axis * a)
{
  TRACE;
  //a->setRange(0.01, 100);
  a->setAutoTicks(false);
  a->setMajorTicks(5);
  a->setMinorTicks(1);
  a->setScaleType(Scale::Log);
}

