/***************************************************************************
**
**  This file is part of gpviewmax.
**
**  gpviewmax is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpviewmax is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-07-16
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef HISTOGRAMSWIDGET_H
#define HISTOGRAMSWIDGET_H

#include <SciFigs.h>
#include <QGpGuiMath.h>
#include <QGpCoreWave.h>

#include "Samples.h"
#include "Reader.h"
#include "ui_HistogramsWidget.h"

class ModeWidgets;

class HistogramsWidget : public QWidget, private Ui::HistogramsWidget
{
  Q_OBJECT
public:
  HistogramsWidget(QWidget * parent=nullptr);
  ~HistogramsWidget();

  void setNormalize(bool n) {_normalize=n;}
  void addWidget(Samples * s, const Reader& param);
  bool splitModes(const Reader& param);
  void setHistogramComments(QString cmt);
  bool classifySamples(const QStringList& filters);
  void exportPlot(const ExportOptions& o);
  void exportHistogramValues(const ExportOptions& o);
private slots:
  void setActivePlot(GraphicObject * o);
  void classifySamples();
  void exportSamples();
  void pickToMean();
  void adjustCurve();

  void addMeanCurve();
  void addMedianCurve();
  void addModeCurve();
  void addGaussianMixtureCurve();
protected:
  void closeEvent(QCloseEvent * e);
  bool splitModesFromCurves(const Reader& param);
  void splitModesFromEllSign(const Reader& param);
  ModeWidgets * mode(AxisWindow * w) const;
  ModeWidgets * currentMode() const;
private:
  bool _normalize;
  QList<ModeWidgets *> _modes;
};

#endif // HISTOGRAMSWIDGET_H

