/***************************************************************************
**
**  This file is part of gpviewmax.
**
**  gpviewmax is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpviewmax is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2022-01-24
**  Copyright: 2022
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef CLASSIFICATIONPARAMETERS_H
#define CLASSIFICATIONPARAMETERS_H

#include "Reader.h"

class ClassificationParameters : public SampleClassificationParameters
{
public:
  ClassificationParameters();
  ClassificationParameters(const ClassificationParameters& o);

  AbstractParameters * clone() const;

  static Reader::Plot data(QString d, bool& ok);
  static QString data(Reader::Plot d);

  Reader::Plot data() const {return _data;}
  void setData(Reader::Plot d) {_data=d;}

  QString toString(PARAMETERS_TOSTRING_ARGS_DECL) const;
  void collectKeywords(PARAMETERS_COLLECTKEYWORDS_ARGS);
protected:
  int keywordCount(PARAMETERS_KEYWORDCOUNT_ARGS) const;
  bool setValue(PARAMETERS_SETVALUE_ARGS);
private:
  Reader::Plot _data;
};

#endif // CLASSIFICATIONPARAMETERS_H

