/***************************************************************************
**
**  This file is part of gpsh.
**
**  gpsh is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpsh is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-09-03
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>
#include <QGpCoreWave.h>

#include "ShReader.h"
#include "gpshVersion.h"
#include "gpshInstallPath.h"

PACKAGE_INFO("gpsh", GPSH)

ApplicationHelp * help();

int main(int argc, char ** argv)
{
  CoreApplication a(argc, argv, help);

  a.setStreamPrefix("gpsh: ");
  ShReader reader;
  if(reader.setOptions(argc, argv) && reader.read(argc, argv) ) {
    return 0;
  } else {
    return 2;
  }
}

ApplicationHelp * help()
{
  ApplicationHelp * h=new ApplicationHelp;
  h->setOptionSummary( "[OPTIONS] [FILE]" );
  h->setComments("Compute SH transfer function for layered models given through stdin or FILE.\n\n"
                 "Format for layered models:\n"
                 + Seismic1DModel::formatHelp() +
                 "\n\n"
                 "Quality factors are mandatory (except if '-qp' and '-qs' option are provided. "
                 "Any number of models can be given as input.");
  h->addGroup("Gpsh","gpsh");
  h->addOption("-n <count>","Number of frequency samples (default=100)");
  h->addOption("-s <sampling>","Defines the sampling type:\n"
                              "  period     regular sampling in period\n"
                              "  frequency  regular sampling in frequency\n"
                              "  log        regular sampling in log(frequency) (default)");
  h->addOption("-min <min>","Minimum of range for SH transfer function (default=0.2 Hz)");
  h->addOption("-max <max>","Maximum of range for SH transfer function (default=20 Hz)");
  h->addOption("-qp <Qp>","Attenuation factor for P waves for all layers (default=0, keep Qp of each layer)");
  h->addOption("-qs <Qs>","Attenuation factor for S waves for all layers (default=0, keep Qs of each layer)");
  h->addOption("-receiver-depth <D>","Receiver depth (default=0).");
  h->addOption("-reference-depth <D>","Depth of reference (default=-1 which means incomming basement wave).");
  h->addExample("gpsh < test.model", "Calculate SH transfer function from 0.2 Hz to 20 Hz for model 'test.model'.");
  h->addExample("gpsh < test.model | figue -c", "Calculate the same function and plot it.");
  h->addExample("gpsh < test.model | figue -c -m sh.mkup", "Show the same function on a log-log plot. "
                "'sh.mkup' is a tar.gz file containing an xml description of the graphic format, "
                "it can be generated from figue's interface.");
  return h;
}
