/***************************************************************************
**
**  This file is part of gplivemodel.
**
**  gplivemodel is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gplivemodel is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-06-15
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "ShAmplificationThread.h"

/*!
  \class ShAmplificationThread ShAmplificationThread.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
ShAmplificationThread::ShAmplificationThread(QObject * parent)
    : Seismic1DThread(parent)
{
  TRACE;
}

/*!
  Description of constructor still missing
*/
ShAmplificationThread::ShAmplificationThread(const ShAmplificationThread& o)
    : Seismic1DThread(o)
{
  TRACE;
}

/*!
  Description of destructor still missing
*/
ShAmplificationThread::~ShAmplificationThread()
{
  TRACE;
}

void ShAmplificationThread::initResultsGraphs(GraphicSheet * sheet)
{
  TRACE;
  CurvesThread::initResultsGraphs(sheet);
  AxisWindow * w=_layer->graph();
  w->xAxis()->setFrequency();
  w->yAxis()->setTitle(tr("Sh amplification"));
  w->yAxis()->setTitleInverseScale(tr(""));
}

bool ShAmplificationThread::setParameters(int& argc, char ** argv)
{
  TRACE;
  return CurvesThread::setParameters(argc, argv);
}

void ShAmplificationThread::run(GeophysicalModel * m)
{
  TRACE;
  KennettSH kenn(static_cast<Seismic1DModel *>(m));
  Curve<Point2D> curve;
  for(int i=0; i<_x.count(); i++) {
    double f=_x.at(i);
    curve.append(Point2D(f, kenn.sh(f, 0.0)));
  }
  _curves.append(curve);
}
