/***************************************************************************
**
**  This file is part of gpfksimulator.
**
**  gpfksimulator is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpfksimulator is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2017-01-26
**  Copyright: 2017-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "SourceList.h"

/*!
  \class SourceList SourceList.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

const QString SourceList::xmlSourceListTag="SourceList";

/*!
  Description of constructor still missing
*/
SourceList::SourceList()
  : QList<SourceParameters>()
{
  TRACE;
}

/*!
  Description of destructor still missing
*/
SourceList::~SourceList()
{
  TRACE;
}

void SourceList::xml_writeChildren(XML_WRITECHILDREN_ARGS) const
{
  TRACE;
  for(const_iterator it=begin(); it!=end(); it++) {
    it->xml_save(s, context);
  }
}

XMLMember SourceList::xml_member(XML_MEMBER_ARGS)
{
  Q_UNUSED(attributes)
  Q_UNUSED(context)
  if(tag==SourceParameters::xmlSourceParametersTag) {
    append(SourceParameters());
    return XMLMember(&last());
  } else {
    return XMLMember(XMLMember::Unknown);
  }
}

