/***************************************************************************
**
**  This file is part of gpec8.
**
**  gpec8 is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpec8 is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-03-19
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>
#include <QGpCoreWave.h>
#include "gpec8Version.h"
#include "gpec8InstallPath.h"
#include "EC8Reader.h"

PACKAGE_INFO("gpec8", GPEC8);

ApplicationHelp * help();

int main(int argc, char ** argv)
{
  CoreApplication a(argc, argv, help);

  ApplicationHelp::print("\n\n"
        "*****************\n"
        "IMPORTANT NOTICE:\n"
        "*****************\n\n"
        "We remind you that this software is released to you for free under a GNU Public License. "
        "If you download a binary version of this code, you can still access and review the code yourself "
        "available at http://www.geopsy.org. The definition of EC8 site classes computed here above are "
        "based only on Vs profiles and mainly on Vs30 values. Nspt, Cu and lithology are not taken into "
        "account.\n\n"
        "This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even "
        "the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public "
        "License for more details.","# ");
  // Options
  EC8Reader reader;
  if(reader.setOptions(argc, argv) && reader.read(argc, argv) ) {
    return 0;
  } else {
    return 2;
  }
}

ApplicationHelp * help()
{
  ApplicationHelp * h=new ApplicationHelp;
  h->setOptionSummary( "[OPTIONS] [FILE]" );
  h->setComments( "Print EC8 site class corresponding to intput models\n\n"
                 "Format for layered models:\n"
                 + Seismic1DModel::formatHelp() +
                 "\n\n"
                 "Quality factors are not mandatory. Any number of models can be given as input.");
  return h;
}
