/***************************************************************************
**
**  This file is part of geopsynr.
**
**  geopsynr is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsynr is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-08-28
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef STACKWEIGHTS_H
#define STACKWEIGHTS_H

#include <DinverCore.h>
#include <GeopsyCore.h>

class ShotRecord;

class StackWeights : public AbstractForward
{
  TRANSLATIONS("StackWeights")
public:
  StackWeights(QList<ShotRecord *> shots);

  void setGlobalTimeLimits(const TimeRangeParameters& timeLimits) {_globalTimeLimits=timeLimits;}
  void setSignalTimeLimits(const TimeRangeParameters& timeLimits) {_signalTimeLimits=timeLimits;}
  void setReceiverIndex(int recIndex) {_receiverIndex=recIndex;}
  void setUniformWeights();
  void setWeights(const int * gridWeights);
  void stack(SubSignalPool& results);

  virtual AbstractForward * clone() const;
  virtual double misfit(bool& ok);
private:
  void setParameters();

  QList<ShotRecord *> _shots;
  int _receiverIndex;
  TimeRangeParameters _globalTimeLimits, _signalTimeLimits;
  void param2weights(double * weights);
};

#endif // STACKWEIGHTS_H
