/***************************************************************************
**
**  This file is part of geopsyhv.
**
**  geopsyhv is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsyhv is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-10-10
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpGuiTools.h>

#include "TabHVPreferences.h"
#include "GeopsyHVPrefs.h"


/*
 *  Constructs a Tab_HVPreferences as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 */
TabHVPreferences::TabHVPreferences(QWidget *parent, Qt::WindowFlags f)
    : QWidget(parent, f)
{
  TRACE;
  setupUi(this);

  spectrumOptions->visibleLayerGroup->setTitle(tr("Spectrum options"));
  spectrumOptions->setVisibleLayers(hvPrefs.spectrumVisibleLayers());
  hvOptions->visibleLayerGroup->setTitle(tr("H/V options"));
  hvOptions->setVisibleLayers(hvPrefs.hvVisibleLayers());
  hvOptions->noiseModel->hide();
}

void TabHVPreferences::setPreferences()
{
  TRACE;
  hvPrefs.setHVVisibleLayers(hvOptions->visibleLayers());
  hvPrefs.setSpectrumVisibleLayers(spectrumOptions->visibleLayers());
  hvPrefs.load();
}
