/***************************************************************************
**
**  This file is part of geopsyhv.
**
**  geopsyhv is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsyhv is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-08-23
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "SpectrumResultSheet.h"

/*!
  \class SpectrumResultSheet SpectrumResultSheet.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
SpectrumResultSheet::SpectrumResultSheet(QWidget * parent)
    : CurveResultSheet(parent)
{
  TRACE;
  Settings::getSize(this, "SpectrumResultSheet");
}

SpectrumResultSheet::~SpectrumResultSheet()
{
  TRACE;
  Settings::setSize(this, "SpectrumResultSheet");
}

void SpectrumResultSheet::setWindowTitle(QString subPoolName)
{
  TRACE;
  QWidget::setWindowTitle(tr("Spectrum Results - ")+subPoolName);
}

void SpectrumResultSheet::addActions()
{
  TRACE;
  CurveResultSheet::addActions();
  QAction * a;

  a=new QAction(tr("&Derivate"), this);
  a->setToolTip(tr("Derivate the selected spectra."));
  connect(a, SIGNAL(triggered()), this, SLOT(derivate()));
  menuTools->addAction(a);

  a=new QAction(tr("&Integrate"), this);
  a->setToolTip(tr("Integrate the selected spectra."));
  connect(a, SIGNAL(triggered()), this, SLOT(integrate()));
  menuTools->addAction(a);
}

void SpectrumResultSheet::derivate()
{
  TRACE;
  // Number of graphs per station is 1
  static const QString title=tr("Derivate");
  if(!selectAll(title)) return;
  for(QList<AbstractResultWidget *>::iterator it=_results.begin(); it!=_results.end(); it++) {
    CurveResultWidget * g=static_cast<CurveResultWidget *>(*it);
    CurveResults& s=*g->values();
    if(g->isSelected()) {
      s.derivate();
      g->showValues();
      g->setValueTitle(g->valueTitle()+"*s^2");
    }
  }
}

void SpectrumResultSheet::integrate()
{
  TRACE;
  // Number of graphs per station is 1
  static const QString title=tr("Integrate");
  if( !selectAll(title) ) return;
  for(QList<AbstractResultWidget *>::iterator it=_results.begin(); it!=_results.end(); it++) {
    CurveResultWidget * g=static_cast<CurveResultWidget *>(*it);
    CurveResults& s=*g->values();
    if(g->isSelected()) {
      s.integrate();
      g->showValues();
      g->setValueTitle(g->valueTitle()+"/s^2");
    }
  }
}

AbstractResultWidget * SpectrumResultSheet::createWidget()
{
  CurveResultWidget * w=new CurveResultWidget;
  w->peakLayer()->setOpacity(0.0);
  return w;
}


void SpectrumResultSheet::loadResults()
{
  TRACE;
  MessageContext mc;
  QStringList fileNames;
  fileNames=Message::getOpenFileNames(tr("Load spectrum results"), tr("Spectrum file (*.spec)"));
  CurveResultSheet::loadResults(fileNames);
}
