/***************************************************************************
**
**  This file is part of geopsydamping.
**
**  geopsydamping is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsydamping is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-10-13
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <GeopsyGui.h>

#include "ToolDampingd.h"
#include "Parameters.h"

/*!
  Constructs a ToolDampingd as a child of 'parent', with the
  name 'name' and widget flags set to 'f'.
*/
ToolDampingd::ToolDampingd(QWidget *parent, Qt::WindowFlags f)
    : QWidget(parent, f)
{
  TRACE;
  setupUi(this);
}

/*!
  Destroys the object and frees any allocated resources
*/
ToolDampingd::~ToolDampingd()
{
  TRACE;
  // no need to delete child widgets, Qt does it all for us
}

void ToolDampingd::on_doFilterBut_stateChanged()
{
  TRACE;
  filterWidget->setEnabled(doFilterBut->isChecked());
}

void ToolDampingd::setParameters(const Parameters& param)
{
  TRACE;
  windowLength->setValue(param.windowLength());
  fitLength->setValue(param.fitLength());
  timeLimits->setParameters(param.timeRange());
  if(param.isFilter()) {
    doFilterBut->setChecked(true);
    filterWidget->setParameters(param.filter());
  } else {
    doFilterBut->setChecked(false);
  }
}

void ToolDampingd::getParameters(Parameters& param)
{
  TRACE;
  param.setWindowLength(windowLength->value());
  param.setFitLength(fitLength->value());
  timeLimits->getParameters(param.timeRange());
  if(doFilterBut->isChecked()) {
    filterWidget->getParameters(param.filter());
  }
}
