/***************************************************************************
**
**  This file is part of geopsy.
**
**  geopsy is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsy is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2015-09-21
**  Copyright: 2015-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "WindowEnvironment.h"
#include "MainWindow.h"
#include "GeopsyAboutDialog.h"

/*!
  \class WindowEnvironment WindowEnvironment.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
WindowEnvironment::WindowEnvironment()
  : MultiDocumentEnvironment()
{
  TRACE;

  createFileActions(); // Mostly not used except 'Open recent'
  createWindowsActions();
  createHelpActions();
}

/*!
  Description of destructor still missing
*/
WindowEnvironment::~WindowEnvironment()
{
  TRACE;
}

MultiDocumentWindow * WindowEnvironment::createWindow()
{
  MainWindow * mw=new MainWindow;
  _databases.insert(mw->database(), mw);
  return mw;
}

MainWindow * WindowEnvironment::window(QObject * o)
{
  TRACE;
  return static_cast<MainWindow*>(MultiDocumentEnvironment::window(o));
}

MainWindow * WindowEnvironment::window(QWidget * w)
{
  TRACE;
  return static_cast<MainWindow*>(MultiDocumentEnvironment::window(w));
}

MainWindow * WindowEnvironment::window(SignalDatabase * db)
{
  TRACE;
  QMap<SignalDatabase *, MainWindow *>& databases=instance()->_databases;
  QMap<SignalDatabase *, MainWindow *>::iterator it=databases.find(db);
  if(it!=databases.end()) {
    return it.value();
  } else {
    return databases.begin().value();
  }
}

void WindowEnvironment::helpDocumentation()
{
  TRACE;
  QUrl doc("http://www.geopsy.org/wiki/index.php/Geopsy");
  QDesktopServices::openUrl(doc);
}

void WindowEnvironment::helpAbout()
{
  TRACE;
  GeopsyAboutDialog * d=new GeopsyAboutDialog;
  d->exec();
  delete d;
}
