/***************************************************************************
**
**  This file is part of geopsy.
**
**  geopsy is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsy is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2003-11-10
**  Copyright: 2003-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef TABLEWINDOW_H
#define TABLEWINDOW_H

#include <GeopsyGui.h>

class SignalTableView;

class TableWindow: public SubPoolWindow
{
  Q_OBJECT
public:
  TableWindow (QWidget* parent=0);
  ~TableWindow ();

  virtual void setWindowTitle(QString title);
  virtual void subPoolUpdate();
  virtual void fastFourierTransform(DoubleSignal::SignalType st);
  void setEditionLocked(bool l);
  virtual QSize sizeHint() const;
public slots:
  void exportTable ();
  void importTable ();
  void getSelection(SubSignalPool& sel);
  void setDataFields();
  virtual void beginSignalChange(Signal * sig=0);
  virtual void endSignalChange(Signal * sig=0);
  void resizeCells();
private:
  SignalTableView * _headers;
  EventRestrictor _resizeCells;

  virtual void resizeEvent(QResizeEvent *);
};

#endif // TABLEWINDOW_H
