/***************************************************************************
**
**  This file is part of geopsy.
**
**  geopsy is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsy is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-05-25
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef SORTKEYSMODEL_H
#define SORTKEYSMODEL_H

#include <QtGui>

class SortKeysModel : public QAbstractTableModel
{
public:
  SortKeysModel(QObject * parent=nullptr);
  ~SortKeysModel();

  int rowCount(const QModelIndex& parent) const;
  int columnCount(const QModelIndex& parent) const;
  QVariant data(const QModelIndex& index, int role) const;
  QVariant headerData(int section, Qt::Orientation orientation, int rol) const;
  bool setData(const QModelIndex& index, const QVariant& value, int role);
  Qt::ItemFlags flags(const QModelIndex& index) const;

  void add();
  void remove(QModelIndexList l);
  QModelIndexList moveUp(QModelIndexList l);
  QModelIndexList moveDown(QModelIndexList l);

  void load();
  void save();

  static const QString ascending, descending;
};

#endif // SORTKEYSMODEL_H

