/***************************************************************************
**
**  This file is part of geopsy.
**
**  geopsy is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsy is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-09-20
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <GeopsyGui.h>

#include "SortKeys.h"
#include "SortKeysModel.h"
#include "SortKeysDelegate.h"
#include "ui_SortKeys.h"

/*!
  Constructs a SortKeys as a child of 'parent', with the
  name \a name and widget flags set to \a fl.
*/
SortKeys::SortKeys(QWidget *parent)
    : Dialog(parent), _ui(new Ui::SortKeys)
{
  TRACE;
  _ui->setupUi(this);

  _ui->keys->setModel(new SortKeysModel(this));
  _ui->keys->setItemDelegate(new SortKeysDelegate(this));
  _ui->keys->horizontalHeader()->setSectionResizeMode(0, QHeaderView::Stretch);

  connect(_ui->keys->selectionModel(),
          SIGNAL(selectionChanged(const QItemSelection &, const QItemSelection &)),
          this,
          SLOT(setButtonsState()));
  load();
}

SortKeysModel * SortKeys::model() const
{
  return static_cast<SortKeysModel *>(_ui->keys->model());
}

/*!
  Load keys from registry
*/
void SortKeys::load()
{
  TRACE;
  model()->load();

  Settings::columnWidth(_ui->keys, "SortKeys");
  Settings::getWidget(this);
}

/*!
  Save keys to registry
*/
void SortKeys::save() const
{
  TRACE;
  model()->save();

  Settings::setColumnWidth(_ui->keys, "SortKeys");
  Settings::setWidget(this);
}

void SortKeys::setButtonsState()
{
  TRACE;
  bool selected=(_ui->keys->model()->rowCount()>0 &&
                 _ui->keys->currentIndex().isValid());
  _ui->remove->setEnabled(selected);
  _ui->moveUp->setEnabled(selected);
  _ui->moveDown->setEnabled(selected);
}

void SortKeys::on_add_clicked()
{
  TRACE;
  model()->add();
}

void SortKeys::on_remove_clicked()
{
  TRACE;
  QItemSelectionModel * sel=_ui->keys->selectionModel();
  QModelIndexList l=sel->selectedRows();
  model()->remove(l);
  sel->select(_ui->keys->currentIndex(), QItemSelectionModel::Select | QItemSelectionModel::Rows);
}

void SortKeys::on_moveUp_clicked()
{
  TRACE;
  QItemSelectionModel * sel=_ui->keys->selectionModel();
  QModelIndexList l=sel->selectedRows();
  l=model()->moveUp(l);
  QModelIndex index;
  foreach(index, l) {
    sel->select(index, QItemSelectionModel::Select | QItemSelectionModel::Rows);
  }
}

void SortKeys::on_moveDown_clicked()
{
  TRACE;
  QItemSelectionModel * sel=_ui->keys->selectionModel();
  QModelIndexList l=sel->selectedRows();
  l=model()->moveDown(l);
  QModelIndex index;
  foreach(index, l) {
    sel->select(index, QItemSelectionModel::Select | QItemSelectionModel::Rows);
  }
}
