/***************************************************************************
**
**  This file is part of geopsy.
**
**  geopsy is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsy is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2019-08-30
**  Copyright: 2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include <GeopsyGui.h>

#include "SeismicEventDelegate.h"

/*!
  \class SeismicEventDelegate SeismicEventDelegate.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

QWidget * SeismicEventDelegate::createEditor(QWidget * parent, const QStyleOptionViewItem &,
                                             const QModelIndex &index) const
{
  TRACE;
  switch(index.column()) {
  case 2: {
      QComboBox * w=createComboBox(parent);
      w->addItems(UtmZone::names());
      return w;
    }
  case 3:
  case 4:
  case 5: {
      DoubleSpinBox * w=createDoubleSpinBox(parent);
      w->setMinimum(-std::numeric_limits<double>::infinity());
      w->setMaximum(std::numeric_limits<double>::infinity());
      w->setDecimals(3);
      return w;
    }
  case 7: {
      QComboBox * w=createComboBox(parent);
      w->addItems(SeismicEvent::userTypes());
      return w;
    }
  default:
    return createLineEdit(parent);
  }
}

