/***************************************************************************
**
**  This file is part of geopsy.
**
**  geopsy is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsy is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-05-18
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "PickEvents.h"
#include "ui_PickEvents.h"

PickEvents::PickEvents(QWidget *parent) :
  Dialog(parent), ui(new Ui::PickEvents)
{
  TRACE;
  ui->setupUi(this);
}

PickEvents::~PickEvents()
{
  TRACE;
  delete ui;
}

void PickEvents::updateAllFields()
{
  TRACE;
   ui->pickParameters->updateAllFields();
}

void PickEvents::on_previewButton_clicked()
{
  TRACE;
  PickParameters param;
  ui->pickParameters->getParameters(param);
  removeEvents();
  _myEvents=_subPoolWin->subPool().pickEvents(param);
  updateSignals();
}

void PickEvents::pickEvents()
{
  TRACE;
  if(_myEvents.isEmpty()) {
    PickParameters param;
    ui->pickParameters->getParameters(param);
    _myEvents=_subPoolWin->subPool().pickEvents(param);
    updateSignals();
  }
}

void PickEvents::removeEvents()
{
  TRACE;
  if(!_myEvents.isEmpty()) {
    _subPoolWin->subPool().database()->seismicEvents()->remove(_myEvents);
    _myEvents.clear();
    updateSignals();
  }
}

void PickEvents::updateSignals()
{
  AbstractGraphicWindow * g=qobject_cast<AbstractGraphicWindow *>(_subPoolWin);
  if(g) {
    g->signalLayer()->deepUpdate();
  }
}
