/***************************************************************************
**
**  This file is part of geopsy.
**
**  geopsy is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsy is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-02-19
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef GROUPVIEW_H
#define GROUPVIEW_H

#include <GeopsyGui.h>

class SigSelectionDnD;
class MainWindow;

class GroupView : public QTreeView
{
  Q_OBJECT
public:
  GroupView(QWidget * parent=nullptr);

  enum Mode{Browse, Signals, Rename, Sort};

  virtual QSize sizeHint() const;

  void addActions();
  void setMode(Mode m);
  void select(const QRegularExpression& exp);
public slots:
  void acceptDrop(const QPoint& pos, bool& ok);
  void getSelection(SubSignalPool& sel);
  void addSignals(QWidget * /*parent*/, const SubSignalPool& sel);

  SubPoolWindow * newTableWindow();
  SubPoolWindow * newGraphicWindow();
  SubPoolWindow * newMapWindow();
  SubPoolWindow * newChronogramWindow();
  void newTool();
  void remove();
  void properties();
  void newFolder();
  void newGroup();
  void emptyGroup();
protected:
  virtual void contextMenuEvent (QContextMenuEvent * e);
  virtual void mouseDoubleClickEvent (QMouseEvent * e);
private:
  QList<AbstractSignalGroup *> getSelection(bool readWriteOnly, bool warn=false);
  void select(AbstractSignalGroup * parent, const QRegularExpression& exp);
  inline SignalGroupItem * model() const;

  Mode _mode;
  QAction * _propertiesAction;
  QAction * _removeAction;
  QAction * _graphicAction;
  QAction * _tableAction;
  QAction * _mapAction;
  QAction * _chronogramAction;
  QAction * _newFolderAction;
  QAction * _newGroupAction;
  QAction * _emptyGroupAction;
  QAction * _expandAllAction;
  QAction * _collapseAllAction;
  SigSelectionDnD * _sigDnD;
  QMenu * _menu;

  QModelIndex _lastIndex;
  QElapsedTimer _lastDrop;
};


#endif // GROUPVIEW_H
