/***************************************************************************
**
**  This file is part of dinvermatlab.
**
**  This file is distributed under the terms of the Geopsy.org Commercial
**  License appearing in the file LICENSE.COMMERCIAL included in the packaging
**  of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See Geopsy.org Commercial License for
**  more details.
**
**  You should have received a copy of the Geopsy.org Commercial License
**  along with this program. If not, see <http://www.geopsy.org>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-11-23
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MATLABTARGET_H
#define MATLABTARGET_H

#include <QGpCoreTools.h>

#define MATLAB_OUTPUT_BUFFER_SIZE 4096

class MatlabTarget : public XMLClass
{
  TRANSLATIONS("MatlabTarget")
public:
  MatlabTarget() {}
  MatlabTarget(const MatlabTarget& o);

  virtual const QString& xml_tagName() const {return xmlMatlabTargetTag;}
  static const QString xmlMatlabTargetTag;

  bool isEmpty() const {return _forwardScript.isEmpty();}
  bool isOk(int nParams);

  void setStartup(QString s) {_startup=s;}
  QString startup() const {return _startup;}

  void setScriptPath(QString s) {_scriptPath=s;}
  QString scriptPath() const {return _scriptPath;}

  void setInitScript(QString s) {_initScript=s;}
  QString initScript() const {return _initScript;}

  void setForwardScript(QString s) {_forwardScript=s;}
  QString forwardScript() const {return _forwardScript;}
protected:
  virtual void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
  virtual XMLMember xml_member(XML_MEMBER_ARGS);
  virtual bool xml_setProperty(XML_SETPROPERTY_ARGS);
private:
  QString _startup, _scriptPath, _initScript, _forwardScript;
};

#endif // MATLABTARGET_H
