/***************************************************************************
**
**  This file is part of dinverdc.
**
**  dinverdc is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  dinverdc is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-10-31
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PARAMPROFILEWIDGET_H
#define PARAMPROFILEWIDGET_H

#include <DinverCore.h>
#include <DinverDCCore.h>
#include "ui_ParamProfileWidget.h"
#include "ParamLayerWidget.h"

class ParamGroundModelWidget;

class ParamProfileWidget : public QWidget, public Ui::ParamProfileWidget
{
  Q_OBJECT

public:
  ParamProfileWidget(ParamGroundModelWidget * parent=0, Qt::WindowFlags f=Qt::Widget);
  ~ParamProfileWidget();

  ParamProfile * paramProfile();
  QList<ParamLayerWidget *> layers();
  QList<ParamLayerWidget *> interfaces();

  int nLayers() const {return _nLayers;}

  ParamProfile::Type type() {return _type;}
  const QString & shortName() {return _shortName;}
  const QString & unit() {return _unit;}
  double defaultMinimum() const {return _defaultMinimum;}
  double defaultMaximum() const {return _defaultMaximum;}
  SimpleCondition::Type defaultCondition() const {return _defaultCondition;}
  void setEditable(bool e);
public slots:
  void setParam(QString shortName, QString longName, QString unit, double defaultMinimum, double defaultMaximum,
                 ParamProfile::Type type, SimpleCondition::Type defaultCondition);
  ParamLayerWidget * addLayer();
  void deleteLayer();
  void deleteAllLayers();
  void setLayerIndex();
  void on_moveUp_clicked();
  void on_moveDown_clicked();
  void unselectAll();
  void setDHLinks(QList<ParamLayerWidget *> layerList);
  void setFrom(ParamProfile * p);
  void setLinksFrom(ParamProfile * p);
signals:
  void updateDHLinks();
  void updateSize();
private:
  ParamLayerWidget * layer(int index) const;
  int selectedIndex() const;
  ParamLayerWidget * createLayer();

  ParamGroundModelWidget * _groundModel;
  int _nLayers;

  QVBoxLayout * _frameLayout;
  double _defaultMinimum, _defaultMaximum;
  QString _shortName;
  QString _unit;
  QString _longName;
  SimpleCondition::Type _defaultCondition;
  ParamProfile::Type _type;
};

#endif // QTBPARAMPROFILEWIDGET_H
