/***************************************************************************
**
**  This file is part of dinverdc.
**
**  dinverdc is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  dinverdc is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-03-02
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ELLIPTICITYPEAKTARGETWIDGET_H
#define ELLIPTICITYPEAKTARGETWIDGET_H

#include <QGpGuiTools.h>
#include <QGpCoreMath.h>

#include "ui_EllipticityPeakTargetWidget.h"

class EllipticityPeakTargetWidget : public QWidget,
                                    public WidgetRect,
                                    private Ui::EllipticityPeakTargetWidget
{
  Q_OBJECT
public:
  EllipticityPeakTargetWidget(QWidget * parent=nullptr);
  ~EllipticityPeakTargetWidget();

  void setValue(const RealStatisticalValue& val);
  RealStatisticalValue value() const;

  void setMinimumAmplitude(double val);
  double minimumAmplitude() const;

  void loadHVGeopsy(QString fileName);
  void loadReport(QString fileName);
  void setEditable(bool e);
protected:
  void resizeEvent(QResizeEvent * e);
private slots:
  void on_loadBut_clicked();
  void on_minimumAmplitudeEdit_valueChanged(double v);
signals:
  void peakModified();
};

#endif // ELLIPTICITYPEAKTARGETWIDGET_H
