/***************************************************************************
**
**  This file is part of dinver.
**
**  dinver is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  dinver is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-10-26
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PSViewer_H
#define PSViewer_H

#include <SciFigs.h>

#include "ModelThreadInfo.h"
#include "InversionThread.h"

class ModelSelector;

class ViewerThreadInfo
{
public:
  ViewerThreadInfo() {
    alreadyLoaded=SetIndex::first;
  }
  SetIndex alreadyLoaded;
};

typedef QMap<const InversionThread *, ViewerThreadInfo *> ViewerThreadMap;

class PSViewer : public QWidget
{
  Q_OBJECT
public:
  PSViewer(QWidget * parent=nullptr);
  ~PSViewer();

  void lockPlots();
  void unlockPlots();
  void addThreadData(InversionThread * models);
  const ModelThreadList& modelList() const {return *_selectedModels;}
  const ViewerThreadMap& threads() const {return _threads;}
  void lockDataModels();
  void unlockDataModels();
  const ColorMap * colorMap() const {return &_colorMap->colorMap();}
  bool saveParameters() const {return _saveParameters;}
  const InversionThread * parameterList() const {
    if(_threads.isEmpty()) return 0; else return _threads.begin().key();
  }
public slots:
  void synchronize();
  void setLimits();
  void addPlot();
  void fileOpenPS();
  void fileSavePS();
  void fileSaveAsPS();
  void select();
  void setRange(int paramIndex, double min, double max);
  void setMaximumIndex(int index);
  void setMinimumIndex(int index);
  AxisWindow * addPlot(int paramX, int paramY);
private:
  GraphicSheet _sheet;
  ColorMapWidget * _colorMap;
  QVBoxLayout* _childLayout;
#ifndef Q_OS_DARWIN
  QMenuBar * _menuBar;
#endif

  ViewerThreadMap _threads;
  ModelThreadList _models;
  ModelThreadList * _selectedModels;
  VectorList<QPair<double, double>> _selectedRange;
  SetIndex _minimumIndex, _maximumIndex;

  bool _saveParameters;

  ModelSelector * _selector;

  void addActions();
  void initSelectedRange();
  void selectModels();
};

#endif
