/***************************************************************************
**
**  This file is part of dinver.
**
**  dinver is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  dinver is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-10-26
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef NAModelsPlot_H
#define NAModelsPlot_H

#include <QGpCoreTools.h>
#include <SciFigs.h>
#include "PSViewer.h"

class PSViewer;
class TabNAModelsPlot;

class NAModelsPlot : public GraphContentsLayer
{
  Q_OBJECT
  Q_PROPERTY(double dotDiameter READ dotDiameter WRITE setDotDiameter)
public:
  NAModelsPlot(AxisWindow * parent=nullptr);
  ~NAModelsPlot();

  const QString& xml_tagName() const;
  static const QString xmlNAModelsPlotTag;

  Rect boundingRect() const;
  void setParent(GraphContents * parent);

  void setParamX(int px);
  void setParamY(int py);
  int paramX() const {return _paramX;}
  int paramY() const {return _paramY;}
  double dotDiameter() const {return _size;}
  void setDotDiameter (double d) {_size=d;}

  bool hasProperties() {return true;}
  void addProperties(PropertyProxy * pp);
  void removeProperties(PropertyProxy * pp);
  void properties(PropertyWidget * w) const;
  void setProperty(uint wid, int pid, QVariant val);
protected:
  void paintData(const LayerPainterRequest& lp, QPainter& p, double dotpercm) const;
  void setAxisProperties(int paramIndex, Axis * axis);

  mutable PSViewer * _psViewer;
  int _paramX, _paramY;
  double _size;
  static uint _tab;

  bool saveParameters() const;
  void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
  void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  void xml_writeBinaryData(XML_WRITEBINARYDATA_ARGS) const;
  XMLMember xml_member(XML_MEMBER_ARGS);
  bool xml_setProperty(XML_SETPROPERTY_ARGS);
private:
  void paramValue(double& x, double& y, double& misfit,
                  const InversionThread * t,
                  const SetIndex& index) const;
  void paramValue(double& x, double& y, double& misfit,
                  ModelThreadList::const_iterator it) const;
};

#endif
