/***************************************************************************
**
**  This file is part of dinver.
**
**  dinver is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  dinver is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-04-01
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef LAUNCHTHREADTABLE_H
#define LAUNCHTHREADTABLE_H

#include <QGpGuiTools.h>

#include "ModelThreadInfo.h"

class LaunchThreadTable : public TableView
{
  Q_OBJECT
public:
  LaunchThreadTable(QWidget * parent=nullptr);
  ~LaunchThreadTable() {}

  ThreadList selectedThreads(bool& allOfTheSameType);
  bool isThreadSelected(int index) {return selectionModel()->isRowSelected(index, rootIndex());}

  InversionThread * currentEditableThread();
};

#endif // LAUNCHTHREADTABLE_H
