/***************************************************************************
**
**  This file is part of dinver.
**
**  dinver is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  dinver is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2015-12-14
**  Copyright: 2015-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ENGINE_H
#define ENGINE_H

#include <DinverCore.h>

#include "WindowEnvironment.h"

class Engine : public DinverCoreEngine
{
public:
  static Engine * instance() {return static_cast<Engine *>(DinverCoreEngine::instance());}

  virtual inline MultiDocumentSubWindow * addSubWindow(QWidget * parent, QWidget * w);
  virtual inline void removeSubWindow(QWidget * w);
  virtual inline void activateSubWindow(QWidget * w);

  virtual QStringList selectedReports(QWidget *parent, const QString& title) const;
  virtual QList<const AbstractForward *> forwardList(QWidget *parent, const QStringList& reports) const;

  virtual bool useProgress() {return true;}
  virtual void setProgressMaximum(QObject * parent, int value);
  virtual int progressMaximum(QObject * parent);
  virtual void setProgressValue(QObject * parent, int value);
  virtual AbstractProgress * progress(QObject * parent);
  virtual void showMessage(QObject * parent, QString msg);

  virtual bool isModified(QObject * parent) const;
  virtual void setModified(QObject * parent, bool m);
};

inline MultiDocumentSubWindow * Engine::addSubWindow(QWidget * parent, QWidget * w)
{
  return WindowEnvironment::instance()->addSubWindow(parent, w);
}

inline void Engine::removeSubWindow(QWidget * w)
{
  WindowEnvironment::instance()->removeSubWindow(w);
}

inline void Engine::activateSubWindow(QWidget * w)
{
  WindowEnvironment::instance()->activateSubWindow(w);
}

#endif // ENGINE_H

