/***************************************************************************
**
**  This file is part of dinver.
**
**  dinver is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  dinver is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2015-12-14
**  Copyright: 2015-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "Engine.h"
#include "WindowEnvironment.h"
#include "MainWindow.h"

/*!
  \class Engine Engine.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

void Engine::setProgressMaximum(QObject * parent, int value)
{
  TRACE;
  if(WindowEnvironment::instance()) {
    WindowEnvironment::window(parent)->setProgressMaximum(value);
  }
}

int Engine::progressMaximum(QObject * parent)
{
  TRACE;
  if(WindowEnvironment::instance()) {
    return WindowEnvironment::window(parent)->progressMaximum();
  } else {
    return 0;
  }
}

void Engine::setProgressValue(QObject * parent, int value)
{
  TRACE;
  if(WindowEnvironment::instance()) {
    WindowEnvironment::window(parent)->setProgressValue(value);
  }
}

AbstractProgress * Engine::progress(QObject * parent)
{
  TRACE;
  if(WindowEnvironment::instance()) {
    return WindowEnvironment::window(parent)->progress();
  } else {
    return nullptr;
  }
}

void Engine::showMessage(QObject * parent, QString msg)
{
  TRACE;
  if(WindowEnvironment::instance()) {
    WindowEnvironment::window(parent)->showMessage(msg);
  }
}

bool Engine::isModified(QObject * parent) const
{
  TRACE;
  MainWindow * w=WindowEnvironment::window(parent);
  if(w) {
    return w->isModified();
  } else {
    return false;
  }
}

void Engine::setModified(QObject *parent, bool m)
{
  TRACE;
  MainWindow * w=WindowEnvironment::window(parent);
  if(w) {
    w->setModified(m);
  }
}

QStringList Engine::selectedReports(QWidget *parent, const QString& title) const
{
  TRACE;
  MainWindow * w=WindowEnvironment::window(parent);
  return w->selectedReports(title);
}

QList<const AbstractForward *> Engine::forwardList(QWidget *parent, const QStringList& reports) const
{
  TRACE;
  MainWindow * w=WindowEnvironment::window(parent);
  return w->forwardList(reports);
}
