/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-07-04
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "XYPlotProperties.h"
#include "ui_XYPlotProperties.h"
#include "LegendTable.h"

namespace SciFigs {

  XYPlotProperties::XYPlotProperties(QWidget * parent)
      : PropertyWidget(parent),
        _ui(new Ui::XYPlotProperties)
  {
    TRACE;
    _ui->setupUi(this);

    addProperty(DotDiameter, _ui->dotDiameter, _ui->dotDiameterLabel);
    addProperty(Symbol, _ui->symbol, _ui->symbolLabel);

    LegendTable::initSymbolTypes(_ui->symbol);
  }

  void XYPlotProperties::removeSymbol()
  {
    delete _ui->symbol;
    _ui->symbol=nullptr;
    delete _ui->symbolLabel;
    _ui->symbolLabel=nullptr;
    removeProperty(Symbol);
  }

} // namespace SciFigs
