/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-12-02
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreMath.h>

#include "ParallelBand.h"

namespace SciFigs {

const QString ParallelBand::xmlParallelBandTag="ParallelBand";

ParallelBand::ParallelBand(const Brush& b, const Pen& p)
  :  _pen(p),
    _brush(b),
    _minimum(0.0),
    _maximum(0.0)
{
}

ParallelBand::ParallelBand(double value, const Pen& p)
  :  _pen(p),
    _brush(Qt::NoBrush),
    _minimum(value),
    _maximum(value)
{
}

ParallelBand::ParallelBand(double min, double max, const Brush& b, const Pen& p)
  :  _pen(p),
    _brush(b),
    _minimum(min),
    _maximum(max)
{
}

void ParallelBand::xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const
{
  TRACE;
  Q_UNUSED(context)
  writeProperty(s, "minimum", _minimum);
  writeProperty(s, "maximum", _maximum);
}

void ParallelBand::xml_writeChildren(XML_WRITECHILDREN_ARGS) const
{
  TRACE;
  _pen.xml_save(s, context);
  _brush.xml_save(s, context);
}

XMLMember ParallelBand::xml_member(XML_MEMBER_ARGS)
{
  TRACE;
  Q_UNUSED(attributes)
  Q_UNUSED(context)
  if(tag=="minimum") return XMLMember(0);
  else if(tag=="maximum") return XMLMember(1);
  else if(tag=="Pen") return XMLMember(&_pen);
  else if(tag=="Brush") return XMLMember(&_brush);
  else if(tag=="limits") return XMLMember(2);  // Kept for compatibility
  return XMLMember(XMLMember::Unknown);
}

bool ParallelBand::xml_setProperty(XML_SETPROPERTY_ARGS)
{
  TRACE;
  Q_UNUSED(tag)
  Q_UNUSED(attributes)
  Q_UNUSED(context)
  bool ok=true;
  switch(memberID) {
  case 0: _minimum=content.toDouble(ok); return ok;
  case 1: _maximum=content.toDouble(ok); return ok;
  case 2: {                 // Kept for compatibility
      Point2D p;
      if(p.fromString(content)) {
        _minimum=p.x();
        _maximum=p.y();
        return true;
      } else {
        return false;
      }
    }
  default:
    return false;
  }
}


} // namespace SciFigs
