/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2002-05-27
**  Copyright: 2002-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef LEGENDTABLE_H
#define LEGENDTABLE_H

#include <QGpGuiTools.h>

#include "Symbol.h"
#include "Legend.h"
#include "SciFigsDLLExport.h"

namespace SciFigs {

class SCIFIGS_EXPORT LegendTable : public TableView
{
  Q_OBJECT
public:
  enum Column {ColumnNull,
               ColumnPenColor, ColumnPenWidth, ColumnPenStyle,
               ColumnSymbolType, ColumnSymbolSize,
               ColumnSymbolPenColor, ColumnSymbolPenWidth, ColumnSymbolPenStyle,
               ColumnSymbolBrushColor, ColumnSymbolBrushStyle,
               ColumnTextColor, ColumnText};
  enum PropertySection {AllSections=0x3F,
                        TextAllSections=0x21,
                        SymbolAllSections=0x1C,
                        TextSection=0x01,
                        PenSection=0x02,
                        SymbolTypeSection=0x04,
                        SymbolPenSection=0x08,
                        SymbolBrushSection=0x10,
                        TextColorSection=0x20};
  Q_DECLARE_FLAGS(PropertySections, PropertySection)

  LegendTable(QWidget *parent=nullptr);

  void setLegend(Legend * legend);
  void setPropertySections(PropertySections s=AllSections);

  void setOneColor(bool oc);
  bool oneColor() const;

  void setReadOnlyText(bool ro);
  bool readOnlyText() const;

  void setConstant(bool c);

  static void initPenStyles(QComboBox * w);
  static Pen::LineStyle penStyle(int index);
  static int penItem(Pen::LineStyle p);

  static void initSymbolTypes(QComboBox * w);
  static Symbol::Type symbolType(int index);
  static int symbolItem(Symbol::Type t);

  static void initBrushStyles(QComboBox * w);
  static Qt::BrushStyle brushStyle(int index);
  static int brushItem(Qt::BrushStyle b);
signals:
  void changed();
private:
  static QPixmap lineStylePixmap(Pen::LineStyle s, const QPalette& palette);
  static QPixmap brushStylePixmap(Qt::BrushStyle s, const QPalette& palette);
  static QPixmap symbolTypePixmap(Symbol::Type t, const QPalette& palette);

  QHash<int,Column> _columnIndexes;
};

} // namespace SciFigs

Q_DECLARE_OPERATORS_FOR_FLAGS(SciFigs::LegendTable::PropertySections)

#endif // LEGENDTABLE_H
