/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-02-27
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef LAYERLOCKER_H
#define LAYERLOCKER_H

#include "GraphContentsLayer.h"
#include "SciFigsDLLExport.h"

namespace SciFigs {


class SCIFIGS_EXPORT LayerLocker
{
public:
  inline LayerLocker(GraphContentsLayer * layer);
  inline ~LayerLocker();

  inline void unlock();
private:
  GraphContentsLayer * _layer;
};

inline LayerLocker::LayerLocker(GraphContentsLayer * layer) : _layer(layer)
{
  if(_layer) _layer->lockDelayPainting();
}

inline LayerLocker::~LayerLocker()
{
  if(_layer) _layer->unlock();
}

inline void LayerLocker::unlock()
{
  if(_layer) {
    _layer->unlock();
    _layer=0;
  }
}

} // namespace SciFigs

#endif // LAYERLOCKER_H
