/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-02-27
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "LayerLocker.h"

namespace SciFigs {

/*!
  \class LayerLocker LayerLocker.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  \fn LayerLocker::LayerLocker(GraphContentsLayer * layer)
  Lock \a layer calling lockDelayPainting(). \a layer can be null.

  Once a layer has been locked this is safe to edit its properties. After unlock(),
  any execution of the event loop may start again the painting operations. If there is
  no execution of the event loop, even after a unlock() or after destructor call, this
  is still safe to edit the \a layer.
*/

/*!
  \fn LayerLocker::~LayerLocker()

  Unlock layer.
*/

/*!
  \fn void LayerLocker::unlock()

  Unlock layer. Compatible with unlock from destructor.
*/

} // namespace SciFigs
