/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-04-02
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef GRAPHCONTENTLAYERPROPERTIES_H
#define GRAPHCONTENTLAYERPROPERTIES_H

#include "ui_GraphContentsLayerProperties.h"
#include "GraphContents.h"

namespace SciFigs {

class LayerPropertiesItem : public QAbstractTableModel
{
  Q_OBJECT
public:
  LayerPropertiesItem(QObject * parent=nullptr) : QAbstractTableModel(parent) {}

  void setGraphs(const QList<GraphContents *>& l);
  void setGraph(GraphContents * g);

  int rowCount(const QModelIndex&) const;
  int columnCount(const QModelIndex &parent=QModelIndex()) const;
  QVariant data(const QModelIndex &index, int role) const;
  QVariant headerData(int section, Qt::Orientation orientation, int role=Qt::DisplayRole) const;
  bool setData (const QModelIndex & index, const QVariant & value, int role=Qt::EditRole);
  Qt::ItemFlags flags (const QModelIndex & ) const;

  int removeLayers(QModelIndexList l);
  QList<GraphContentsLayer *> moveLayersUp(QModelIndexList l);
  QList<GraphContentsLayer *> moveLayersDown(QModelIndexList l);
  void selectLayers(QModelIndexList l);
  void selectAllLayers(bool s);

  QModelIndex indexOf(GraphContentsLayer * l) const;
private:
  static int layerIndex(const GraphContents * graph, const QModelIndex &index);
  const GraphContentsLayer * layer(const GraphContents * graph, const QModelIndex &index) const;
  GraphContentsLayer * layer(GraphContents * graph, const QModelIndex &index);
  bool isNameConstant(const QModelIndex & index) const;
  bool isOpacityConstant(const QModelIndex & index) const;
  bool isCommentConstant(const QModelIndex & index) const;

  QList<GraphContents *> _graphs;
};

class LayerPropertiesDelegate : public ItemDelegate
{
public:
  LayerPropertiesDelegate(QObject *parent=nullptr) : ItemDelegate(parent) {}

  QWidget * createEditor(QWidget * parent, const QStyleOptionViewItem & option, const QModelIndex &index) const;
};

class GraphContentsLayerProperties : public PropertyWidget, private Ui::GraphContentsLayerProperties
{
  Q_OBJECT
public:
  GraphContentsLayerProperties(QWidget * parent=nullptr);
  ~GraphContentsLayerProperties();

  void addGraph(GraphContents * g);
  void removeGraph(GraphContents * g);
  void reset();
private slots:
  void on_currentGraphCombo_currentIndexChanged(int);
  void on_saveLayers_clicked();
  void on_copyLayers_clicked();
  void on_appendLayers_clicked();
  void on_prependLayers_clicked();
  void on_removeLayers_clicked();
  void on_mergeLayers_clicked();
  void on_moveLayerUp_clicked();
  void on_moveLayerDown_clicked();
private:
  void select(LayerPropertiesItem * model, const QList<GraphContentsLayer *>& list);
  static bool graphLessThan(const GraphContents * l1, const GraphContents * l2);
  void setGraphList();
  GraphContents * currentGraph() const;
  LayerPropertiesItem * layerModel() const;

  QList<GraphContents *> _graphList;
  bool _uniqueLayerStack;
};

} // namespace SciFigs

#endif // GRAPHCONTENTLAYERPROPERTIES_H
