/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-05-07
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef COORDTIP_H
#define COORDTIP_H

#include <QtGui>
#if(QT_VERSION > QT_VERSION_CHECK(5, 0, 0))
#include <QtWidgets>
#endif

namespace SciFigs {

class GraphContents;

class CoordTipTip: public QLabel
{
  Q_OBJECT
public:
  CoordTipTip();
protected:
  virtual bool event(QEvent * e);
};

class CoordTip :  public QObject
{
  Q_OBJECT
public:
  CoordTip();
  ~CoordTip();

  void setMousePos(GraphContents * gc,QPoint& pt);

  QString text() const {return _coordTip->text();}
  void setEnabled(bool e);
public slots:
  void hideTip();
protected slots:
  void fallAsleep();
protected:
  bool _enabled;
  QTimer _coordTipTimer;
  QTimer _coordTipShowTimer;
  CoordTipTip * _coordTip;
  QPoint _mousePos;
  GraphContents * _currentGC;
};

} // namespace SciFigs

#endif // COORDTIP_H
