/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-03-28
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef AXISSCALEPROPERTIES_H
#define AXISSCALEPROPERTIES_H

#include "ui_AxisScaleProperties.h"
#include "Axis.h"

namespace SciFigs {

class AxisScaleProperties : public PropertyWidget, private Ui::AxisScaleProperties
{
  Q_OBJECT
public:
  AxisScaleProperties(QWidget * parent=nullptr);

  virtual void setWidgets();
  void setCurrentAxis(Axis * a) {_currentAxis=a;}

  enum Properties {MinimumValue, MaximumValue,
                    MajorTicks, MinorTicks, AutoTicks, ShowLabels, ZoomEnabled,
                    ScaleType, ReversedScale, SizeType, SizeInfo};

  static int scaleType2item(Scale::Type st);
  static Scale::Type item2scaleType(int index);

  static int sizeType2item(Axis::SizeType st);
  static Axis::SizeType item2sizeType(int index);
private:
  virtual PropertyValue::WidgetType determineCustomWidgetType(int pid, QWidget * w, QWidget * label);
  virtual bool connectCustomWidget(PropertyValue & );
  virtual bool setCustomWidget(PropertyValue & p);
  virtual QVariant customWidgetValue(PropertyValue & p);
private slots:
  void on_minZoom_clicked();
  void on_maxZoom_clicked();
  void on_minContent_clicked();
  void on_maxContent_clicked();
  void rangeTouched();
private:
  Axis * _currentAxis;
};

} // namespace SciFigs

#endif // AXISSCALEPROPERTIES_H
