/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-11-03
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ABSTRACTNAMELINE_H
#define ABSTRACTNAMELINE_H

#include "AbstractLine.h"
#include "SciFigsDLLExport.h"

namespace SciFigs {

class SCIFIGS_EXPORT AbstractNameLine : public AbstractLine
{
public:
  AbstractNameLine() {_textDx=0.0; _textDy=0.01; _textOrientation=0.0;}
  AbstractNameLine(const AbstractNameLine& o);

  void operator=(const AbstractLine& o);

  const QString& xml_tagName() const {return xmlAbstractNameLineTag;}
  static const QString xmlAbstractNameLineTag;

  virtual QString name(int index) const=0;
  virtual void setName(int index, QString n)=0;

  QString toString(int index, const CurvePointOptions * options) const;
  bool fromString(int index, const StringSection& str, const QChar *& ptr, const CurvePointOptions *);

  QColor textColor() const {return _textColor;}
  double textDx() const {return _textDx;}
  double textDy() const {return _textDy;}
  double textOrientation() const {return _textOrientation;}

  void setTextColor(const QColor& c) {_textColor=c;}
  void setTextDx(double dx) {_textDx=dx;}
  void setTextDy(double dy) {_textDy=dy;}
  void setTextOrientation(double orientation) {_textOrientation=orientation;}
protected:
  QColor _textColor;
  double _textDx; // distance in cm from centre along X
  double _textDy; // distance in cm from centre along Y
  double _textOrientation; // in degrees (mathematical sense)
protected:
  void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
  bool xml_setProperty(XML_SETPROPERTY_ARGS);
  XMLMember xml_member(XML_MEMBER_ARGS);
};

} // namespace SciFigs

#endif // ABSTRACTNAMELINE_H
