/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-12-09
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SENDMAIL_H
#define SENDMAIL_H

#include <QtCore>

#include "QGpGuiToolsDLLExport.h"

class QTcpSocket;

namespace QGpGuiTools {

class QGPGUITOOLS_EXPORT SendMail : public QObject
{
  Q_OBJECT
public:
  SendMail(const QString &smtp, const QString &from, const QString &to,
              const QString &subject, const QString &body,
              const QStringList * files=0);
  ~SendMail();
public slots:
  void send();
private slots:
  void readyRead();
  void connected();
  void dataWritten(qint64 nbytes);
signals:
  void dataProgressValue(int val);
  void dataProgressMaximum(int val);
  void status(const QString &);
  void finished(bool);
private:
  QString encode(uchar * buf, int bufLen);
  void addAttachments(); 
  void cleanTmpDir(QDir& tmp);
  enum State {
    Init,
    Mail,
    Rcpt,
    Data,
    Body,
    Quit,
    Close
  };

  QString _smtp;
  QString _message;
  QString _from;
  QString _to;
  QStringList _files;

  QTcpSocket * _socket;
  QTextStream * _t;
  int _state;
  int _dataWritten;
};

} // namespace QGpGuiTools

#endif // SENDMAIL_H
