/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-03-31
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PROPERTYCATEGORY_H
#define PROPERTYCATEGORY_H

#include <QtGui>
#include <QGpCoreTools.h>

#include "QGpGuiToolsDLLExport.h"

namespace QGpGuiTools {

  class PropertyTab;
  class PropertyItem;
  class PropertyWidget;
  class ExpandTabWidget;

  class QGPGUITOOLS_EXPORT PropertyCategory
  {
  public:
    PropertyCategory();
    ~PropertyCategory();

    void setEditor(ExpandTabWidget * editor);

    void setId(unsigned int id) {_id=id;}
    unsigned int id() const {return _id;}

    void setIcon(QIcon icon) {_icon=icon;}
    QIcon icon() const {return _icon;}

    void setCaption(QString caption) {_caption=caption;}
    QString caption() const {return _caption;}

    PropertyTab * find(uint tab);
    PropertyTab * addTab(uint tab, QString title, PropertyWidget * w, PropertyItem * item);

    void removeTab(uint tab, PropertyItem * item, ExpandTabWidget * editor);
    bool isEmpty() const;

    void setValues();

    static uint uniqueId();
    static uint idCount() {return _lastUniqueId;}
    static uint invalidId;
  private:
    static uint _lastUniqueId;

    QIcon _icon;
    uint _id;
    QString _caption;
    PropertyTab ** _tabs;
  };

} // namespace QGpGuiTools

#endif // PROPERTYCATEGORY_H
