/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-06-23
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>

#include "MultiDocumentTab.h"
#include "MultiDocumentSubWindow.h"

namespace QGpGuiTools {

/*!
  \class MultiDocumentTab MultiDocumentTab.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
MultiDocumentTab::MultiDocumentTab(QWidget * parent)
    : QMdiArea(parent)
{
  TRACE;
  setAttribute(Qt::WA_DeleteOnClose);
  setHorizontalScrollBarPolicy(Qt::ScrollBarAsNeeded);
  setVerticalScrollBarPolicy(Qt::ScrollBarAsNeeded);

  QMenu * m=new QMenu(this);
  _windowMenuAction=new QAction(tr("Unamed"), this);
  _windowMenuAction->setMenu(m);
  connect(_windowMenuAction, SIGNAL(triggered()), this, SLOT(activate()));
}

/*!
  Description of destructor still missing
*/
MultiDocumentTab::~MultiDocumentTab()
{
  TRACE;
}

void MultiDocumentTab::activate()
{
  TRACE;
  emit activateRequested(this);
}

void MultiDocumentTab::setName(const QString& n)
{
  TRACE;
  _windowMenuAction->setText(n);
  emit nameChanged();
}

QString MultiDocumentTab::name() const
{
  TRACE;
  QList<QMdiSubWindow *>	wList=QMdiArea::subWindowList(QMdiArea::CreationOrder);
  if(wList.count()==1) {
    QString t=wList.first()->windowTitle();
    if(t.size()>35) {
      return t.left(35)+"...";
    } else {
      return t;
    }
  } else {
    return _windowMenuAction->text();
  }
}

QList<MultiDocumentSubWindow *> MultiDocumentTab::subWindowList() const
{
  TRACE;
  QList<MultiDocumentSubWindow *> l;
  QList<QMdiSubWindow *>	wList=QMdiArea::subWindowList(QMdiArea::CreationOrder);
  l.reserve(wList.count());
  foreach(QMdiSubWindow * subw, wList) {
    l.append(qobject_cast<MultiDocumentSubWindow *>(subw));
  }
  return l;
}

bool MultiDocumentTab::closeAllSubWindows()
{
  TRACE;
  QList<QMdiSubWindow *>	wList;
  wList=QMdiArea::subWindowList(QMdiArea::CreationOrder);
  int i=0;
  while(i<wList.count()) {
    MultiDocumentSubWindow * w=static_cast<MultiDocumentSubWindow *>(wList.at(i));
    if(w->close()) {
      removeSubWindow(w);
      // Why regenerating the list? Because closing a window may
      // close also other windows listed in wList, so we are forced
      // to update this list at each step.
      QGuiApplication::processEvents(QEventLoop::ExcludeUserInputEvents);
      wList=QMdiArea::subWindowList(QMdiArea::CreationOrder);
    } else {
      i++;
    }
  }
  return wList.isEmpty();
}

void MultiDocumentTab::addSubWindow(MultiDocumentSubWindow * w)
{
  TRACE;
  MultiDocumentTab * oldTab=w->tab();
  if(oldTab && oldTab!=this) {
    oldTab->removeSubWindow(w);
  }
  connect(w, SIGNAL(windowTitleChanged(const QString&)), this, SIGNAL(nameChanged()));
  connect(w, SIGNAL(destroyed(QObject *)), this, SIGNAL(nameChanged()));
  QMdiArea::addSubWindow(w);
  _windowMenuAction->menu()->addAction(w->windowMenuAction());
  emit nameChanged();
}

void MultiDocumentTab::removeSubWindow(MultiDocumentSubWindow * w)
{
  TRACE;
  _windowMenuAction->menu()->removeAction(w->windowMenuAction());
  disconnect(w, SIGNAL(windowTitleChanged(const QString&)), this, SIGNAL(nameChanged()));
  disconnect(w, SIGNAL(destroyed(QObject *)), this, SIGNAL(nameChanged()));
  QMdiArea::removeSubWindow(w);
  emit nameChanged();
}

void MultiDocumentTab::moveSubWindow()
{
  TRACE;
  QAction * a=qobject_cast<QAction *>(sender());
  if(!a) {
    return;
  }
  MultiDocumentSubWindow * w=static_cast<MultiDocumentSubWindow *>(a->data().value<void *>());
  addSubWindow(w);
}

} // namespace QGpGuiTools
